<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:fn="http://www.w3.org/2004/10/xpath-functions" 
xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
xmlns:xlink="http://www.w3.org/1999/xlink"
xmlns:gml="http://www.opengis.net/gml/3.2" 
xmlns:egb="urn:gugik:specyfikacje:gmlas:ewidencjaGruntowBudynkow:1.0" 
xmlns:omg="urn:gugik:specyfikacje:gmlas:ogolnyModelGeodezyjny:1.0" 
xmlns:omp="urn:gugik:specyfikacje:gmlas:ogolnyModelPrzestrzenny:1.0" 
xmlns:otmz="urn:gugik:specyfikacje:gmlas:bazaDanychObiektowTopograficzntychMapyZasadniczej:1.0" 
xmlns:rcwn="urn:gugik:specyfikacje:gmlas:rejestrCenWartosciNieruchomosci:1.0">	
	<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>
		
	<!-- FEATURE COLLECTION -->
	<!-- change egb:FeatureCollection to gml:FeatureCollection-->
	<xsl:template match="egb:FeatureCollection">
		<xsl:element name="gml:FeatureCollection">
			<!-- copy of prefixes and namespaces -->
			<xsl:copy-of select="document('')/xsl:stylesheet/namespace::*[local-name()='xsi' or local-name()='xlink' or local-name()='gml' or local-name()='egb' or local-name()='omg' or local-name()='omp' or local-name()='otmz' or local-name()='rcwn']"/>
				
			<!-- change xsi:schemaLocation value -->
			<xsl:attribute name="xsi:schemaLocation">
				<xsl:text>urn:gugik:specyfikacje:gmlas:ewidencjaGruntowBudynkow:1.0 egb.xsd</xsl:text>
			</xsl:attribute>
				
			<xsl:attribute name="gml:id">
				<xsl:text>idFeatureCollection_</xsl:text>
				<xsl:number count="*" format="1" level="any"/>
			</xsl:attribute>
					
				<!-- TEMPLATE FOR OTHER ELEMENTS -->	
				<xsl:apply-templates select="node()"/>
				
		</xsl:element>
	</xsl:template>
		
		
	<xsl:template match="node()">
		<xsl:variable name="nazwaValue" select="descendant::*[local-name()='NAZWA']"/>
			
			<xsl:choose>
				<!-- ==========  Dokument  ========== -->
				<xsl:when test="$nazwaValue='Dokument'">
					<xsl:element name="gml:featureMember">
						<xsl:element name="egb:Dokument">
							<xsl:attribute name="gml:id">
								<xsl:text>idDokument_</xsl:text>
								<xsl:value-of select="descendant::*[local-name()='IDOBIEKTU']"/>
							</xsl:attribute>
								
							<xsl:element name="omp:startObiekt">
								<xsl:value-of select="descendant::*[local-name()='STARTOBIEKT']"/>
							</xsl:element>
							<xsl:element name="omp:startWersjaObiekt">
								<xsl:value-of select="descendant::*[local-name()='STARTWERSJAOBIEKT']"/>
							</xsl:element>
							<xsl:element name="omp:nazwa">
								<xsl:value-of select="$nazwaValue"/>
							</xsl:element>
								
							<xsl:element name="egb:dataDokumentu">
								<xsl:variable name="dataDokValue" select="descendant::*[local-name()='DATADOKUMENTU']"/>
								<xsl:value-of select="substring-before($dataDokValue,'T')"/>
							</xsl:element>
								
							<xsl:element name="egb:dataPrzyjeciaDoZasobu">
								<xsl:variable name="dataPrzyjeciaDoZasobuValue" select="descendant::*[local-name()='DATAPRZYJECIADOZASOBU']"/>
								<xsl:choose>
									<xsl:when test="$dataPrzyjeciaDoZasobuValue">
										<xsl:value-of select="substring-before($dataPrzyjeciaDoZasobuValue,'T')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:text>0001-01-01</xsl:text>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:element>
								
							<xsl:variable name="opisDokumentuValue" select="descendant::*[local-name()='OPISDOKUMENTU']"/>
							<xsl:if test="$opisDokumentuValue!=0">
								<xsl:element name="egb:opisDokumentu">
									<xsl:value-of select="$opisDokumentuValue"/>
								</xsl:element>
							</xsl:if>
								
							<xsl:element name="egb:oznDokumentu">
							<xsl:variable name="oznDokumentuValue" select="descendant::*[local-name()='OZNDOKUMENTU']"/>
								<xsl:choose>
									<xsl:when test="$oznDokumentuValue!=0">
										<xsl:value-of select="$oznDokumentuValue"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:text>00/00</xsl:text>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:element>
								
							<xsl:element name="egb:rodzajDokumentu">
								<xsl:value-of select="descendant::*[local-name()='RODZAJDOKUMENTU']"/>
							</xsl:element>
							<xsl:element name="egb:sygnaturaDokumentu">
								<xsl:value-of select="descendant::*[local-name()='SYGNATURADOKUMENTU']"/>
							</xsl:element>
								
							<xsl:variable name="dokumentZwiazanyValue" select="descendant::*[local-name()='DOKUMENTZWIAZANY']"/>
							<xsl:if test="$dokumentZwiazanyValue!=0">
								<xsl:if test="contains($dokumentZwiazanyValue,';')=1">
									<xsl:call-template name="T_Xlink">
										<xsl:with-param name="elementNameValue" select="'dokumentZwiazany'"/>
										<xsl:with-param name="idObjectValue" select="'idDokument_'"/>
										<xsl:with-param name="idListValue" select="$dokumentZwiazanyValue"/>
									</xsl:call-template>
								</xsl:if>
								<xsl:if test="contains($dokumentZwiazanyValue,';')=0">
									<xsl:element name="egb:dokumentZwiazany">
										<xsl:attribute name="xlink:href">
											<xsl:text>urn:gugik:specyfikacje:gmlas:ewidencjaGruntowBudynkow:1.0#</xsl:text>
											<xsl:value-of select="'idDokument_'"/>
											<xsl:value-of select="$dokumentZwiazanyValue"/>
										</xsl:attribute>
									</xsl:element>
								</xsl:if>
							</xsl:if>
								
							<xsl:variable name="zmianaValue" select="descendant::*[local-name()='ZMIANA']"/>
							<xsl:if test="$zmianaValue!=0">
								<xsl:if test="contains($zmianaValue,';')=1">
									<xsl:call-template name="T_Xlink">
										<xsl:with-param name="elementNameValue" select="'zmiana'"/>
										<xsl:with-param name="idObjectValue" select="'idZmiana_'"/>
										<xsl:with-param name="idListValue" select="$zmianaValue"/>
									</xsl:call-template>
								</xsl:if>
								<xsl:if test="contains($zmianaValue,';')=0">
									<xsl:element name="egb:zmiana">
										<xsl:attribute name="xlink:href">
											<xsl:text>urn:gugik:specyfikacje:gmlas:ewidencjaGruntowBudynkow:1.0#</xsl:text>
											<xsl:value-of select="'idZmiana_'"/>
											<xsl:value-of select="$zmianaValue"/>
										</xsl:attribute>
									</xsl:element>
								</xsl:if>
							</xsl:if>
								
							<xsl:variable name="wystawiajacyValue" select="descendant::*[local-name()='WYSTAWIAJACY']"/>
							<xsl:if test="$wystawiajacyValue!=0">
								<xsl:if test="contains($wystawiajacyValue,';')=1">
									<xsl:call-template name="T_Xlink">
										<xsl:with-param name="elementNameValue" select="'wystawiajacy'"/>
										<xsl:with-param name="idObjectValue" select="'idInstytucja_'"/>
										<xsl:with-param name="idListValue" select="$wystawiajacyValue"/>
									</xsl:call-template>
								</xsl:if>
								<xsl:if test="contains($wystawiajacyValue,';')=0">
									<xsl:element name="egb:wystawiajacy">
										<xsl:attribute name="xlink:href">
											<xsl:text>urn:gugik:specyfikacje:gmlas:ewidencjaGruntowBudynkow:1.0#</xsl:text>
											<xsl:value-of select="'idInstytucja_'"/>
											<xsl:value-of select="$wystawiajacyValue"/>
										</xsl:attribute>
									</xsl:element>
								</xsl:if>
							</xsl:if>
								
						</xsl:element>
					</xsl:element>
				</xsl:when>
				
			</xsl:choose>
		
	</xsl:template>	
	
	<!-- ========== CutID ========== -->
	<xsl:template name="T_CutID">
		<xsl:param name="stringValue"/>
		<xsl:param name="elNaValue"/>
		<xsl:param name="idObValue"/>
		<xsl:variable name="resultValue" select="substring-before($stringValue,';')"/>
		<xsl:element name="egb:{$elNaValue}">
			<xsl:attribute name="xlink:href">
				<xsl:text>urn:gugik:specyfikacje:gmlas:ewidencjaGruntowBudynkow:1.0#</xsl:text>
				<xsl:value-of select="$idObValue"/>
				<xsl:value-of select="$resultValue"/>
			</xsl:attribute>
		</xsl:element>
	</xsl:template>
		
	<!-- ========== Xlink ========== -->
	<xsl:template name="T_Xlink">
		<xsl:param name="elementNameValue"/>
		<xsl:param name="idObjectValue"/>
		<xsl:param name="idListValue"/>
		<xsl:param name="middleListValue" select="substring-after($idListValue,';')"/>
			
			<xsl:choose>
				<xsl:when test="contains($idListValue,';')=1">
					<xsl:call-template name="T_CutID">
						<xsl:with-param name="elNaValue" select="$elementNameValue"/>
						<xsl:with-param name="idObValue" select="$idObjectValue"/>
						<xsl:with-param name="stringValue" select="$idListValue"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:element name="egb:{$elementNameValue}">
						<xsl:attribute name="xlink:href">
							<xsl:text>urn:gugik:specyfikacje:gmlas:ewidencjaGruntowBudynkow:1.0#</xsl:text>
							<xsl:value-of select="$idObjectValue"/>
							<xsl:value-of select="$idListValue"/>
						</xsl:attribute>
					</xsl:element>
				</xsl:otherwise>
			</xsl:choose>
			
			<xsl:choose>
				<xsl:when test="contains($middleListValue,';')=1">
					<xsl:call-template name="T_Xlink">
						<xsl:with-param name="elementNameValue" select="$elementNameValue"/>
						<xsl:with-param name="idObjectValue" select="$idObjectValue"/>
						<xsl:with-param name="idListValue" select="$middleListValue"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:element name="egb:{$elementNameValue}">
						<xsl:attribute name="xlink:href">
							<xsl:text>urn:gugik:specyfikacje:gmlas:ewidencjaGruntowBudynkow:1.0#</xsl:text>
							<xsl:value-of select="$idObjectValue"/>
							<xsl:value-of select="$middleListValue"/>
						</xsl:attribute>
					</xsl:element>
				</xsl:otherwise>
			</xsl:choose>
			
	</xsl:template>
		
</xsl:stylesheet>
